/*
 * Decompiled with CFR 0.152.
 */
package dioscuri.module.cpu32;

import dioscuri.module.cpu32.ByteSource;
import dioscuri.module.cpu32.CodeBlockCompiler;
import dioscuri.module.cpu32.CodeBlockFactory;
import dioscuri.module.cpu32.Decoder;
import dioscuri.module.cpu32.ProtectedModeCodeBlock;
import dioscuri.module.cpu32.RealModeCodeBlock;
import dioscuri.module.cpu32.Virtual8086ModeCodeBlock;

public class DefaultCodeBlockFactory
implements CodeBlockFactory {
    private Decoder decoder;
    private CodeBlockCompiler compiler;

    public DefaultCodeBlockFactory(Decoder decoder, CodeBlockCompiler codeBlockCompiler) {
        this.decoder = decoder;
        this.compiler = codeBlockCompiler;
    }

    @Override
    public RealModeCodeBlock getRealModeCodeBlock(ByteSource byteSource) {
        return this.compiler.getRealModeCodeBlock(this.decoder.decodeReal(byteSource));
    }

    @Override
    public ProtectedModeCodeBlock getProtectedModeCodeBlock(ByteSource byteSource, boolean bl) {
        return this.compiler.getProtectedModeCodeBlock(this.decoder.decodeProtected(byteSource, bl));
    }

    @Override
    public Virtual8086ModeCodeBlock getVirtual8086ModeCodeBlock(ByteSource byteSource) {
        return this.compiler.getVirtual8086ModeCodeBlock(this.decoder.decodeVirtual8086(byteSource));
    }
}

